#ifndef _H_MAME_WRAP_
#define _H_MAME_WRAP_

#include "config.h"
#ifndef NO_STDLIB_IN_EXTERN_C
# ifdef __cplusplus
extern "C" {
# endif /* __cplusplus */
#endif /* !NO_STDLIB_IN_EXTERN_C */
#include <stdlib.h>
#include <stddef.h>
#include <stdio.h>
#include <stdarg.h>
#ifndef NO_STDLIB_IN_EXTERN_C
# ifdef __cplusplus
}
# endif /* __cplusplus */
#endif /* !NO_STDLIB_IN_EXTERN_C */

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
#if WORDS_BIGENDIAN
#undef LSB_FIRST
#else
#define LSB_FIRST
#endif

#ifdef i386
/*#define X86_ASM*/
#endif

#define HAS_YM2612 1
#define HAS_RF5C68 1

#ifndef OSD_CPU_H
#define OSD_CPU_H
typedef Bit8s   INT8;
typedef Bit8u  UINT8;
typedef Bit16s  INT16;
typedef Bit16u UINT16;
typedef Bit32s  INT32;
typedef Bit32u UINT32;
#endif

#define INLINE inline

/* ---------------------------------------------------------- */

/* these defines is bollow from Xmame source */

typedef UINT32 offs_t;
typedef UINT32 data_t;
typedef data_t (*mem_read_handler)(offs_t offset);
typedef void (*mem_write_handler)(offs_t offset,data_t data);

#ifdef __gcc__
#define READ_HANDLER(name)   data_t name(offs_t __attribute__ ((unused)) offset)
#define WRITE_HANDLER(name)  void name(offs_t __attribute__ ((unused)) offset,data_t __attribute__ ((unused)) data)
ess)
#else
#define READ_HANDLER(name)   data_t name(offs_t offset)
#define WRITE_HANDLER(name)  void name(offs_t offset,data_t data)
#endif

#define MAX_SOUND 5
#include "sndintrf.h"
struct MachineDriver
{
        int sound_attributes;
	float frames_per_second;
        struct MachineSound sound[MAX_SOUND];
};

struct RunningMachine
{
	int sample_rate;        /* the digital audio sample rate; 0 if sound is disabled. */
	const struct MachineDriver *drv;        /* same as gamedrv->drv */
	struct GameSamples *samples;
};

extern struct RunningMachine *Machine;

#define profiler_mark(dummy)

/* flags for sound_attributes */
#define SOUND_SUPPORTS_STEREO           0x0001

/* ---------------------------------------------------------- */

void logerror(const char *text,...);
unsigned cpu_get_pc(void);

int osd_fread(void *file,void *buffer,int length);
int osd_fwrite(void *file,const void *buffer,int length);
int osd_start_audio_stream(int stereo);
int osd_update_audio_stream(INT16 *buffer);
void osd_stop_audio_stream(void);

void fm_pcm_interrupt(int bank);

void freesamples(struct GameSamples *samples);
#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* _H_MAME_WRAP_ */
